//
//  TodoItemRow.swift
//  Do It
//
//  Created by Jim Dovey on 9/5/19.
//  Copyright © 2019 Jim Dovey. All rights reserved.
//

import SwiftUI

struct TodoItemRow: View {
    // START:RowUpdates
    @ObservedObject var item: TodoItem //<label id="code.7.item.row.state"/>
    
    var body: some View {
        HStack {
            Button(action: {
                self.item.complete.toggle()
                UIApplication.shared.saveContext() //<label id="code.7.item.row.save"/>
            }) {
                // <literal:elide> ... </literal:elide>
                // END:RowUpdates
                Image(systemName: item.complete
                        ? "largecircle.fill.circle"
                        : "circle")
                    .imageScale(.large)
                    .foregroundColor(.accentColor)
                // START:RowUpdates
            }
            .padding(.trailing, 6)
            .buttonStyle(HighPriorityButtonStyle())

            VStack(alignment: .leading) {
                Text(item.title ?? "") //<label id="code.7.item.row.title.nil"/>
                    .font(.headline)
                    .foregroundColor(.primary)
                    .padding(.bottom, 2)
                // <literal:elide> ... </literal:elide>
                // END:RowUpdates

                if item.date != nil {
                    Text("\(item.date!, formatter: Formatters.optionalTime(in: item.date!))")
                        .font(.caption)
                        .foregroundColor(.secondary)
                }
                // START:RowUpdates
            }
        }
    }
    // END:RowUpdates
}

struct TodoItemRow_Previews: PreviewProvider {
    static var previews: some View {
        // START:Preview
        return TodoItemRow(item: PreviewDataStore.shared.sampleItem)
            .padding()
            .previewLayout(.sizeThatFits)
            .environment(\.managedObjectContext, PreviewDataStore.shared.viewContext)
        // END:Preview
    }
}
